/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.sequencediagram.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.java.amateras.uml.model.AbstractUMLModel;
import net.java.amateras.uml.sequencediagram.model.ActivationModel;
import net.java.amateras.uml.sequencediagram.model.ActorModel;
import net.java.amateras.uml.sequencediagram.model.InstanceModel;
import net.java.amateras.uml.sequencediagram.model.InteractionModel;
import net.java.amateras.uml.sequencediagram.model.MessageAcceptableModel;
import net.java.amateras.uml.sequencediagram.model.MessageModel;
import net.java.amateras.uml.sequencediagram.model.MessageOrderUtil;
import net.java.amateras.uml.sequencediagram.model.ReturnMessageModel;
import net.java.amateras.uml.sequencediagram.model.SyncMessageModel;
import net.java.amateras.xstream.XStreamSerializer;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class SequenceModelBuilder {
    private InteractionModel root = new InteractionModel();
    private ActivationModel current;
    private Stack<SyncMessageModel> messageStack = new Stack();
    private Map<Object, SyncMessageModel> messageMap = new HashMap<Object, SyncMessageModel>();
    private int currentY = 0;

    public SequenceModelBuilder() {
        this.root.setShowIcon(true);
    }

    public InstanceModel createInstance(String instanceName) {
        InstanceModel model = new InstanceModel();
        model.setName(instanceName);
        model.setConstraint(new Rectangle(120 * this.root.getInstances().size() + 20, 20, 100, -1));
        Rectangle lineRect = model.getConstraint().getCopy();
        lineRect.translate(new Point(50, 0));
        lineRect.width = 5;
        lineRect.height = 200;
        model.getModel().setConstraint(lineRect);
        this.root.addInstance(model);
        this.root.copyPresentation(model);
        return model;
    }

    public ActorModel createActor(String instanceName) {
        ActorModel model = new ActorModel();
        model.setName(instanceName);
        model.setConstraint(new Rectangle(120 * this.root.getInstances().size() + 20, 20, 100, -1));
        Rectangle lineRect = model.getConstraint().getCopy();
        lineRect.translate(new Point(50, 0));
        lineRect.width = 5;
        lineRect.height = 200;
        model.getModel().setConstraint(lineRect);
        this.root.addInstance(model);
        this.root.copyPresentation(model);
        return model;
    }

    public void init(InstanceModel instance) {
        ActivationModel model = new ActivationModel();
        model.setConstraint(new Rectangle(instance.getConstraint().x + 45, 70, 10, 20));
        instance.getModel().addActivation(model);
        this.current = model;
        this.currentY = 70;
        instance.copyPresentation(this.current);
    }

    public void back(String key) {
        MessageModel model = this.messageMap.get(key);
        this.back(model);
    }

    public void back(MessageModel model) {
        if (model != null) {
            ActivationModel source;
            MessageAcceptableModel target = (MessageAcceptableModel)model.getTarget();
            this.current = source = (ActivationModel)model.getSource();
            this.currentY = target instanceof ActivationModel ? target.getConstraint().y + target.getConstraint().height + 20 : target.getConstraint().y + target.getConstraint().height + 40;
        }
    }

    public void endMessage() {
        if (!this.messageStack.isEmpty()) {
            MessageModel model = this.messageStack.pop();
            this.back(model);
        }
    }

    public MessageModel createMessage(String message, String instanceName) {
        InstanceModel model = this.createInstance(instanceName);
        return this.createMessage(message, model);
    }

    public MessageModel createMessage(String message, InstanceModel target) {
        ActivationModel model = new ActivationModel();
        this.current.copyPresentation(model);
        ActivationModel targetModel = this.getTargetModel(this.currentY, target);
        if (targetModel == null) {
            model.setConstraint(new Rectangle(target.getConstraint().x + 45, this.currentY, 10, 20));
            target.getModel().addActivation(model);
        } else {
            model.setConstraint(new Rectangle(target.getConstraint().x + 45 + this.current.getNestLevel() * 5, this.current.getConstraint().y + 20, 10, 20));
            targetModel.addActivation(model);
        }
        SyncMessageModel messageModel = new SyncMessageModel();
        messageModel.setName(message);
        messageModel.setSource(this.current);
        messageModel.setTarget(model);
        messageModel.attachSource();
        messageModel.attachTarget();
        this.current.copyPresentation(messageModel);
        this.messageStack.push(messageModel);
        ReturnMessageModel returnMessageModel = new ReturnMessageModel();
        returnMessageModel.setSource(model);
        returnMessageModel.setTarget(this.current);
        returnMessageModel.attachSource();
        returnMessageModel.attachTarget();
        this.current.copyPresentation(returnMessageModel);
        this.messageMap.put(String.valueOf(this.current.getOwnerLine().getOwner().getName()) + "-" + message + "-" + target.getName(), messageModel);
        model.computeCaller();
        this.current = model;
        this.currentY += 20;
        return messageModel;
    }

    public MessageModel createSelfCallMessage(String message) {
        ActivationModel model = new ActivationModel();
        this.current.copyPresentation(model);
        this.currentY += 20;
        model.setConstraint(new Rectangle(this.current.getConstraint().x + 5, this.currentY, 10, 20));
        this.current.addActivation(model);
        SyncMessageModel messageModel = new SyncMessageModel();
        messageModel.setName(message);
        messageModel.setSource(this.current);
        messageModel.setTarget(model);
        messageModel.attachSource();
        messageModel.attachTarget();
        this.current.copyPresentation(messageModel);
        this.messageStack.push(messageModel);
        model.computeCaller();
        this.current = model;
        this.currentY += 20;
        return messageModel;
    }

    public MessageModel createCreationMessage(String message, String instanceName) {
        InstanceModel model = this.createInstance(instanceName);
        return this.createCreationMessage(message, model);
    }

    public MessageModel createCreationMessage(String message, InstanceModel target) {
        Rectangle rectangle = target.getConstraint().getCopy();
        Point p = rectangle.getTopLeft();
        p.y = this.currentY;
        rectangle.setLocation(p);
        target.setConstraint(rectangle);
        SyncMessageModel messageModel = new SyncMessageModel();
        messageModel.setName(message);
        messageModel.setSource(this.current);
        messageModel.setTarget(target);
        messageModel.attachSource();
        messageModel.attachTarget();
        this.messageStack.push(messageModel);
        ActivationModel newModel = new ActivationModel();
        newModel.setMovable(false);
        Point actP = rectangle.getBottom().getCopy().getTranslated(-5, 20);
        target.copyPresentation(newModel);
        target.getModel().addActivation(newModel);
        target.setActive(newModel);
        newModel.setConstraint(new Rectangle(actP, new Dimension(10, 20)));
        this.current = newModel;
        this.currentY += 40;
        return messageModel;
    }

    private ActivationModel getTargetModel(int y, InstanceModel target) {
        List<AbstractUMLModel> children = target.getModel().getChildren();
        for (ActivationModel activationModel : children) {
            if (activationModel.getConstraint().y >= y || activationModel.getConstraint().y + activationModel.getConstraint().height <= y) continue;
            return activationModel;
        }
        return null;
    }

    public String toXML() {
        MessageOrderUtil.computeMessageOrders(this.root);
        this.root.adjustLifeLine();
        return XStreamSerializer.serialize((Object)this.root, (ClassLoader)this.getClass().getClassLoader());
    }
}

