/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.sequencediagram.model;

import net.java.amateras.uml.sequencediagram.model.MessageAcceptableModel;
import net.java.amateras.uml.sequencediagram.model.MessageModel;
import org.eclipse.draw2d.geometry.Rectangle;

public class SyncMessageModel
extends MessageModel {
    private static final long serialVersionUID = 8393983245605292948L;
    public static final String P_ORDER = "_order";
    public static final int DELTA_Y = 20;
    private int order;
    private int oldOrder;
    private static int number = 1;

    public SyncMessageModel() {
        this.setName("");
    }

    @Override
    public void attachSource() {
        super.attachSource();
        ++number;
    }

    @Override
    public void detachSource() {
        super.detachSource();
        --number;
    }

    public void setOrder(int order) {
        this.oldOrder = this.order;
        this.order = order;
        this.firePropertyChange(P_ORDER, new Integer(this.oldOrder), new Integer(this.order));
    }

    public int getOrder() {
        return this.order;
    }

    public void updateCallee(Rectangle delta) {
        MessageAcceptableModel target = (MessageAcceptableModel)this.getTarget();
        target.updateLocation(delta);
    }

    public void updateCaller(int size) {
        MessageAcceptableModel source = (MessageAcceptableModel)this.getSource();
        source.computeCaller(size);
    }

    public int getCalleeSize() {
        MessageAcceptableModel target = (MessageAcceptableModel)this.getTarget();
        return target.getCalleeSize();
    }

    public boolean isRecursive() {
        MessageAcceptableModel source = (MessageAcceptableModel)this.getSource();
        MessageAcceptableModel target = (MessageAcceptableModel)this.getTarget();
        return source.equals(target.getOwner());
    }
}

