/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.sequencediagram.property;

import java.util.ArrayList;
import java.util.List;
import net.java.amateras.uml.classdiagram.model.Argument;
import net.java.amateras.uml.classdiagram.model.AttributeModel;
import net.java.amateras.uml.classdiagram.model.OperationModel;
import net.java.amateras.uml.model.AbstractUMLModel;
import net.java.amateras.uml.sequencediagram.ClassModelImageResolver;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.contentassist.TextContentAssistSubjectAdapter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class MessageTextCellEditor
extends TextCellEditor {
    private List<?> umlModel = new ArrayList();

    public MessageTextCellEditor() {
    }

    public MessageTextCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    public MessageTextCellEditor(Composite parent) {
        super(parent);
    }

    public void setUMLModel(List<?> umlModel) {
        this.umlModel = umlModel;
    }

    protected Control createControl(Composite parent) {
        super.createControl(parent);
        TextContentAssistSubjectAdapter adapter = new TextContentAssistSubjectAdapter(this.text);
        SubjectControlContentAssistant assistant = new SubjectControlContentAssistant();
        assistant.install((IContentAssistSubjectControl)adapter);
        assistant.setContentAssistProcessor((IContentAssistProcessor)new ContentAssistProcessor(), "__dftl_partition_content_type");
        adapter.appendVerifyKeyListener((VerifyKeyListener)new CodeCompilationKeyListener(this.text, parent, assistant, adapter));
        return this.text;
    }

    class CodeCompilationKeyListener
    implements VerifyKeyListener {
        private Composite composite;
        private SubjectControlContentAssistant assistant;
        private TextContentAssistSubjectAdapter adapter;

        public CodeCompilationKeyListener(Text text, Composite composite, SubjectControlContentAssistant assistant, TextContentAssistSubjectAdapter adapter) {
            this.composite = composite;
            this.assistant = assistant;
            this.adapter = adapter;
        }

        public void verifyKey(final VerifyEvent event) {
            if (event.stateMask == 262144 && event.character == ' ') {
                this.assistant.showPossibleCompletions();
                event.doit = false;
            }
            if (event.character == '\u001b') {
                this.composite.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (CodeCompilationKeyListener.this.assistant.hasProposalPopupFocus()) {
                            MessageTextCellEditor.this.text.forceFocus();
                        } else {
                            CodeCompilationKeyListener.this.adapter.removeVerifyKeyListener((VerifyKeyListener)CodeCompilationKeyListener.this);
                            event.doit = false;
                        }
                    }
                });
            }
        }
    }

    class ContentAssistProcessor
    implements ISubjectControlContentAssistProcessor {
        ContentAssistProcessor() {
        }

        public ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
            int caretPosition = MessageTextCellEditor.this.text.getCaretPosition();
            String previouse = MessageTextCellEditor.this.text.getText().substring(0, caretPosition);
            ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
            for (AbstractUMLModel model : MessageTextCellEditor.this.umlModel) {
                CompletionProposal proposal = this.createProposal(model, previouse, documentOffset);
                if (proposal == null || !proposal.getDisplayString().startsWith(previouse)) continue;
                result.add(proposal);
            }
            ICompletionProposal[] proposals = new ICompletionProposal[result.size()];
            result.toArray(proposals);
            return proposals;
        }

        private CompletionProposal createProposal(AbstractUMLModel model, String previouse, int documentOffset) {
            String displayString = model.toString();
            Image image = null;
            String replaceString = null;
            if (model instanceof AttributeModel) {
                AttributeModel attr = (AttributeModel)model;
                image = ClassModelImageResolver.getAttributeImage(attr);
                replaceString = attr.getName();
            } else if (model instanceof OperationModel) {
                OperationModel ope = (OperationModel)model;
                image = ClassModelImageResolver.getOperationImage(ope);
                replaceString = this.getOperationReplacementString(ope);
            }
            if (replaceString == null) {
                return null;
            }
            return new CompletionProposal(replaceString, documentOffset - previouse.length(), previouse.length(), replaceString.length(), image, displayString, null, null);
        }

        private String getOperationReplacementString(OperationModel model) {
            StringBuffer sb = new StringBuffer();
            sb.append(model.getName());
            sb.append("(");
            int i = 0;
            while (i < model.getParams().size()) {
                if (i != 0) {
                    sb.append(", ");
                }
                Argument arg = model.getParams().get(i);
                sb.append(arg.getName());
                ++i;
            }
            sb.append(")");
            return sb.toString();
        }

        public IContextInformation[] computeContextInformation(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
            return null;
        }

        public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
            return null;
        }

        public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
            return null;
        }

        public char[] getCompletionProposalAutoActivationCharacters() {
            return null;
        }

        public char[] getContextInformationAutoActivationCharacters() {
            return null;
        }

        public String getErrorMessage() {
            return null;
        }

        public IContextInformationValidator getContextInformationValidator() {
            return null;
        }
    }
}

