/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.usecasediagram.edit;

import java.beans.PropertyChangeEvent;
import java.util.List;
import net.java.amateras.uml.editpart.NamedEntityEditPart;
import net.java.amateras.uml.figure.EntityFigure;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.usecasediagram.figure.SystemFigure;
import net.java.amateras.uml.usecasediagram.figure.UsecaseFigureFactory;
import net.java.amateras.uml.usecasediagram.model.SystemModel;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

public class SystemEditPart
extends NamedEntityEditPart {
    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.removeEditPolicy("GraphicalNodeEditPolicy");
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new SystemLayoutEditPolicy());
    }

    public IFigure getContentPane() {
        SystemFigure figure = (SystemFigure)this.getFigure();
        return figure.getPanel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals("_children")) {
            this.refreshChildren();
        }
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
    }

    @Override
    protected EntityFigure createEntityFigure() {
        return UsecaseFigureFactory.getSystemFigure();
    }

    protected List<?> getModelChildren() {
        SystemModel model = (SystemModel)this.getModel();
        return model.getChildren();
    }

    private class ChangeConstraintCommand
    extends Command {
        private AbstractUMLEntityModel model;
        private Rectangle constraint;
        private Rectangle oldConstraint;

        private ChangeConstraintCommand() {
        }

        public void execute() {
            this.model.setConstraint(this.constraint);
        }

        public void setConstraint(Rectangle constraint) {
            this.constraint = constraint;
        }

        public void setModel(AbstractUMLEntityModel model) {
            this.model = model;
            this.oldConstraint = model.getConstraint();
        }

        public void undo() {
            this.model.setConstraint(this.oldConstraint);
        }
    }

    private class CreateAddCommand
    extends Command {
        private AbstractUMLEntityModel target;
        private AbstractUMLEntityModel model;
        private AbstractUMLEntityModel container;

        private CreateAddCommand() {
        }

        public void execute() {
            this.container = this.model.getParent();
            this.container.removeChild(this.model);
            this.target.addChild(this.model);
        }

        public void undo() {
            this.target.removeChild(this.model);
            this.container.addChild(this.model);
        }

        public void setTarget(AbstractUMLEntityModel target) {
            this.target = target;
        }

        public void setModel(AbstractUMLEntityModel model) {
            this.model = model;
        }
    }

    private class CreateCommand
    extends Command {
        private AbstractUMLEntityModel root;
        private AbstractUMLEntityModel model;

        private CreateCommand() {
        }

        public void execute() {
            this.root.copyPresentation(this.model);
            this.root.addChild(this.model);
        }

        public void setRootModel(Object root) {
            this.root = (AbstractUMLEntityModel)root;
        }

        public void setModel(Object model) {
            this.model = (AbstractUMLEntityModel)model;
        }

        public void undo() {
            this.root.removeChild(this.model);
        }
    }

    class SystemLayoutEditPolicy
    extends XYLayoutEditPolicy {
        SystemLayoutEditPolicy() {
        }

        protected Command createAddCommand(EditPart child, Object constraint) {
            CreateAddCommand command = new CreateAddCommand();
            command.setModel((AbstractUMLEntityModel)child.getModel());
            command.setTarget((AbstractUMLEntityModel)this.getHost().getModel());
            ChangeConstraintCommand nextCommand = new ChangeConstraintCommand();
            nextCommand.setModel((AbstractUMLEntityModel)child.getModel());
            nextCommand.setConstraint((Rectangle)constraint);
            return command.chain(nextCommand);
        }

        protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
            ChangeConstraintCommand command = new ChangeConstraintCommand();
            command.setModel((AbstractUMLEntityModel)child.getModel());
            command.setConstraint((Rectangle)constraint);
            return command;
        }

        protected Command getCreateCommand(CreateRequest request) {
            CreateCommand command = new CreateCommand();
            Rectangle constraint = (Rectangle)this.getConstraintFor(request);
            AbstractUMLEntityModel model = (AbstractUMLEntityModel)request.getNewObject();
            model.setConstraint(constraint);
            command.setRootModel(this.getHost().getModel());
            command.setModel(model);
            return command;
        }

        protected Command getDeleteDependantCommand(Request request) {
            return null;
        }
    }
}

