/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.usecasediagram.edit;

import java.beans.PropertyChangeEvent;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.editpart.NamedEntityEditPart;
import net.java.amateras.uml.figure.EntityFigure;
import net.java.amateras.uml.usecasediagram.figure.UsecaseFigure;
import net.java.amateras.uml.usecasediagram.figure.UsecaseFigureFactory;
import net.java.amateras.uml.usecasediagram.model.UsecaseModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.Request;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class UsecaseEditPart
extends NamedEntityEditPart {
    @Override
    protected EntityFigure createEntityFigure() {
        return UsecaseFigureFactory.getUsecaseFigure((UsecaseModel)this.getModel());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals("_resource")) {
            UsecaseModel model = (UsecaseModel)this.getModel();
            UsecaseFigure figure = (UsecaseFigure)this.getFigure();
            figure.setLink(model.getResource() != null && model.getFileResource().exists());
        }
    }

    @Override
    public void performRequest(Request req) {
        if (req.getType().equals("open") && this.openEditor()) {
            return;
        }
        super.performRequest(req);
    }

    private boolean openEditor() {
        IWorkbenchWindow window;
        UsecaseModel model = (UsecaseModel)this.getModel();
        if (model.getResource() != null && model.getFileResource().exists() && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            IWorkbenchPage activePage = window.getActivePage();
            try {
                IDE.openEditor((IWorkbenchPage)activePage, (IFile)model.getFileResource());
                return true;
            }
            catch (PartInitException partInitException) {
                MessageDialog.openError((Shell)window.getShell(), (String)UMLPlugin.getDefault().getResourceString("open.resource.title"), (String)UMLPlugin.getDefault().getResourceString("open.resource.message"));
            }
        }
        return false;
    }
}

