/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.usecasediagram.figure;

import net.java.amateras.uml.UMLImageRegistry;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.figure.EntityFigure;
import net.java.amateras.uml.figure.PresentationFigure;
import net.java.amateras.uml.model.AbstractUMLModel;
import net.java.amateras.uml.usecasediagram.model.UsecaseActorModel;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class UsecaseActorFigure
extends Figure
implements EntityFigure,
PresentationFigure {
    private Label name;
    private Label image;

    public UsecaseActorFigure(UsecaseActorModel model) {
        ToolbarLayout layout = new ToolbarLayout();
        layout.setStretchMinorAxis(false);
        layout.setMinorAlignment(0);
        this.setLayoutManager((LayoutManager)layout);
        this.setOpaque(false);
        this.name = new Label();
        this.name.setOpaque(true);
        this.image = new Label();
        if (model.getImagePath() != null) {
            this.setImage(model);
        } else {
            this.image.setIcon(UMLPlugin.getImageDescriptor("icons/actor.gif").createImage());
        }
        this.image.setOpaque(true);
        this.add((IFigure)this.image);
        this.add((IFigure)this.getLabel());
    }

    @Override
    public void updatePresentation(AbstractUMLModel model) {
        this.setBackgroundColor(ColorConstants.white);
        this.name.setBackgroundColor(ColorConstants.white);
    }

    @Override
    public Label getLabel() {
        return this.name;
    }

    @Override
    public Rectangle getCellEditorRectangle() {
        return this.name.getBounds().getCopy();
    }

    public void setImage(UsecaseActorModel model) {
        if (this.image != null && model.getImageFile() != null) {
            Image img = UMLImageRegistry.getImage(model.getImageFile().getLocation().toFile().toURI().toString());
            this.image.setIcon(img);
        } else {
            this.storeDefaultImage();
        }
    }

    public void storeDefaultImage() {
        this.image.setIcon(UMLPlugin.getImageDescriptor("icons/actor.gif").createImage());
    }
}

