/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.usecasediagram.model;

import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.EntityModel;
import net.java.amateras.uml.model.ICloneableModel;
import net.java.amateras.uml.usecasediagram.property.ActorImagePropertyDescriptor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.views.properties.ColorPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class UsecaseActorModel
extends AbstractUMLEntityModel
implements EntityModel,
ICloneableModel {
    private static final long serialVersionUID = 3151848141351317264L;
    public static final String P_IMAGE = "_image";
    private String name;
    private String imagePath;

    public UsecaseActorModel() {
        this.setName("actor");
    }

    @Override
    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChange("_entityName", old, name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setImagePath(String image) {
        String old = this.imagePath;
        this.imagePath = image;
        this.firePropertyChange(P_IMAGE, old, image);
    }

    public IFile getImageFile() {
        if ("".equals(this.imagePath) || this.imagePath == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromPortableString((String)this.imagePath));
    }

    public String getImagePath() {
        return this.imagePath;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"_entityName", UMLPlugin.getDefault().getResourceString("property.name")), new ActorImagePropertyDescriptor(P_IMAGE, UMLPlugin.getDefault().getResourceString("property.image")), new ColorPropertyDescriptor((Object)"_foreground", UMLPlugin.getDefault().getResourceString("property.foreground"))};
    }

    @Override
    public Object getPropertyValue(Object id) {
        if ("_entityName".equals(id)) {
            return this.name;
        }
        if (P_IMAGE.equals(id)) {
            return this.imagePath;
        }
        return super.getPropertyValue(id);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if ("_entityName".equals(id)) {
            this.setName((String)value);
        } else if (P_IMAGE.equals(id)) {
            this.setImagePath((String)value);
        }
        super.setPropertyValue(id, value);
    }

    @Override
    public boolean isPropertySet(Object id) {
        return "_entityName".equals(id) || P_IMAGE.equals(id) || super.isPropertySet(id);
    }

    @Override
    public Object clone() {
        UsecaseActorModel model = new UsecaseActorModel();
        model.setName(this.getName());
        model.setImagePath(this.getImagePath());
        model.setForegroundColor(this.getForegroundColor().getRGB());
        model.setParent(this.getParent());
        model.setConstraint(new Rectangle(this.getConstraint()));
        return model;
    }
}

