/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.usecasediagram.model;

import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.EntityModel;
import net.java.amateras.uml.model.ICloneableModel;
import net.java.amateras.uml.usecasediagram.property.ResourcePropertyDescriptor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.views.properties.ColorPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class UsecaseModel
extends AbstractUMLEntityModel
implements EntityModel,
ICloneableModel {
    private static final long serialVersionUID = 7699710539405690883L;
    public static final String P_RESOURCE = "_resource";
    private static final Dimension MINIMUM_SIZE = new Dimension(100, 40);
    private String name;
    private String resource;

    public UsecaseModel() {
        this.setName("usecase");
    }

    @Override
    public void setConstraint(Rectangle constraint) {
        Dimension size = constraint.getSize();
        if (MINIMUM_SIZE.contains(size)) {
            constraint.setSize(MINIMUM_SIZE);
        }
        super.setConstraint(constraint);
    }

    @Override
    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChange("_entityName", old, name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String file) {
        String old = this.resource;
        this.resource = file;
        this.firePropertyChange(P_RESOURCE, old, file);
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"_entityName", UMLPlugin.getDefault().getResourceString("property.name")), new ResourcePropertyDescriptor(P_RESOURCE, UMLPlugin.getDefault().getResourceString("property.resource")), new ColorPropertyDescriptor((Object)"_background", UMLPlugin.getDefault().getResourceString("property.background")), new ColorPropertyDescriptor((Object)"_foreground", UMLPlugin.getDefault().getResourceString("property.foreground"))};
    }

    @Override
    public Object getPropertyValue(Object id) {
        if ("_entityName".equals(id)) {
            return this.name;
        }
        if (P_RESOURCE.equals(id)) {
            return this.resource;
        }
        return super.getPropertyValue(id);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if ("_entityName".equals(id)) {
            this.setName((String)value);
        } else if (P_RESOURCE.equals(id)) {
            this.setResource((String)value);
        }
        super.setPropertyValue(id, value);
    }

    @Override
    public boolean isPropertySet(Object id) {
        return "_entityName".equals(id) || P_RESOURCE.equals(id) || super.isPropertySet(id);
    }

    public IFile getFileResource() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromPortableString((String)this.resource));
    }

    @Override
    public Object clone() {
        UsecaseModel model = new UsecaseModel();
        model.setName(this.getName());
        model.setResource(this.getResource());
        model.setForegroundColor(this.getForegroundColor().getRGB());
        model.setBackgroundColor(this.getBackgroundColor().getRGB());
        model.setParent(this.getParent());
        model.setConstraint(new Rectangle(this.getConstraint()));
        return model;
    }
}

